﻿/* Location hash management v1.1 */

window.onhashchange = getBrowserHash;

function getBrowserHash() {

    if (location.hash != "") {
        const conceptID = decodeURIComponent(location.hash.replace("#", ""));
        const temp = conceptID.replace("/other", "").replace("/unspecified", "");
        if (temp.match(/[0-9]/g)) {
            ECT.Handler.setBrowserUri('1', conceptID);
        }
    }
}

function setBrowserHash(uri) {

    const newhash = encodeURIComponent(uri.split(" ").map((element) => { if ((element != "&") && (element != "/") && (element != ".")) { return getConceptID(element); } else { return " " + element + " "; } }).join(''));
    if ('#' + newhash != location.hash) {
        let newlocation = document.location.href.substring(0, document.location.href.indexOf('#')); // without hash
        if (newhash != "") {
            newlocation += '#' + newhash;
        }
        history.pushState(null, null, newlocation);
    }
}

function getConceptID(entityURI) {

    let entityAsResidual = "";
    entityURI = String(entityURI);
    if (entityURI.indexOf('other') !== -1) {
        entityURI = entityURI.replace("/other", "");
        entityAsResidual = "/other";
    }
    if (entityURI.indexOf('unspecified') !== -1) {
        entityURI = entityURI.replace("/unspecified", "");
        entityAsResidual = "/unspecified";
    }

    const entityURIArray = entityURI.split('/');
    if ((entityURIArray.length > 0) && (entityURIArray[entityURIArray.length - 1] !== undefined)) {
        const conceptID = entityURIArray[entityURIArray.length - 1];
        if (conceptID.match(/[0-9]/g)) {
            return conceptID + entityAsResidual;
        }
    }

    return "";
}
