﻿import mermaid from 'https://cdn.jsdelivr.net/npm/mermaid@11.4.1/dist/mermaid.esm.min.mjs';

export function Initialize() {
    mermaid.initialize({
        startOnLoad: true,  // Disable auto-start to manually control rendering
        theme: 'base',
        securityLevel: 'loose',
        themeVariables: {
            'primaryColor': '#f8f8ff',
            'primaryTextColor': '#000',
            'primaryBorderColor': '#dcdcdc',
            'lineColor': '#000',
            'noteBkgColor': '#f8f8ff',
            'noteBorderColor': '#dcdcdc',
            'secondaryColor': '#f0f0f0',
            'useMaxWidth': true, // Required to enable zooming without width restrictions
        },
        flowchart: { useMaxWidth: true, curve: "linear" }
    });
}
//export function RenderAll() {
//    console.log("Initializing Mermaid rendering...");
//    mermaid.contentLoaded = false;
//    mermaid.init(undefined, document.querySelectorAll(".mermaid"));
//}
export function RenderAll(diagramDefinition) {
    console.log("Re-rendering Mermaid diagram...");

    // Select the .mermaid element
    const mermaidElement = document.querySelector(".mermaid");

    if (mermaidElement) {
        // Clear the element's content
        mermaidElement.innerHTML = "";

        // Insert the new diagram definition as text
        mermaidElement.textContent = diagramDefinition;
        mermaidElement.removeAttribute('data-processed');

        // Force Mermaid to re-render the diagram
        mermaid.contentLoaded = false;
        mermaid.init(undefined, mermaidElement);
    }
}